<?php

namespace Drupal\vlsuite_collection_hero\Entity\Bundle;

use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\vlsuite_block\Entity\Bundle\VLSuiteBlockBase;
use Drupal\vlsuite_bundle_field\BundleField\VLSuiteBundleFieldBackgroundTrait;
use Drupal\vlsuite_bundle_field\BundleField\VLSuiteBundleFieldCtaTrait;
use Drupal\vlsuite_bundle_field\BundleField\VLSuiteBundleFieldMediaTrait;
use Drupal\vlsuite_bundle_field\BundleField\VLSuiteBundleFieldTextTrait;

/**
 * Bundle class for VLSuiteCollectionHero.
 */
class VLSuiteCollectionHero extends VLSuiteBlockBase {

  const BUNDLE_KEY = 'vlsuite_collection_hero';

  use VLSuiteBundleFieldCtaTrait {
    VLSuiteBundleFieldCtaTrait::bundleFieldDefinitions as bundleFieldDefinitionsCta;
  }

  use VLSuiteBundleFieldTextTrait {
    VLSuiteBundleFieldTextTrait::bundleFieldDefinitions as bundleFieldDefinitionsText;
  }

  use VLSuiteBundleFieldMediaTrait {
    VLSuiteBundleFieldMediaTrait::bundleFieldDefinitions as bundleFieldDefinitionsMedia;
  }

  use VLSuiteBundleFieldBackgroundTrait {
    VLSuiteBundleFieldBackgroundTrait::bundleFieldDefinitions as bundleFieldDefinitionsBackground;
  }

  /**
   * {@inheritdoc}
   */
  public static function bundleFieldDefinitions(EntityTypeInterface $entity_type, $bundle, array $base_field_definitions): array {
    $fields = parent::bundleFieldDefinitions($entity_type, $bundle, $base_field_definitions);

    $fields += self::bundleFieldDefinitionsText($entity_type, $bundle, $base_field_definitions);
    $fields += self::bundleFieldDefinitionsMedia($entity_type, $bundle, $base_field_definitions);
    $fields['vlsuite_media']->setRequired(FALSE);
    $fields += self::bundleFieldDefinitionsBackground($entity_type, $bundle, $base_field_definitions);
    $fields['vlsuite_background']->setRequired(FALSE);
    $fields += self::bundleFieldDefinitionsCta($entity_type, $bundle, $base_field_definitions);
    $fields['vlsuite_link']->setRequired(FALSE);

    return $fields;
  }

}
