<?php

namespace Drupal\vlsuite_icon_font\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\Core\Field\FieldItemInterface;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;
use Drupal\vlsuite_icon_font\VLSuiteIconFontHelper;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Plugin implementation of the 'VLSuiteIconFontIconFormatter' formatter.
 *
 * @FieldFormatter(
 *   id = "vlsuite_icon_font_icon",
 *   label = @Translation("Icon (VLSuite Icon font)"),
 *   field_types = {
 *     "vlsuite_icon_font_icon",
 *   }
 * )
 */
class VLSuiteIconFontIconFormatter extends FormatterBase {

  /**
   * The icon font helper.
   *
   * @var \Drupal\vlsuite_icon_font\VLSuiteIconFontHelper
   */
  protected $iconFontHelper;

  /**
   * Constructs a "VLSuiteIconFontIconFormatter" formatter class.
   *
   * @param string $plugin_id
   *   The plugin_id for the formatter.
   * @param mixed $plugin_definition
   *   The plugin implementation definition.
   * @param \Drupal\Core\Field\FieldDefinitionInterface $field_definition
   *   The definition of the field to which the formatter is associated.
   * @param array $settings
   *   The formatter settings.
   * @param string $label
   *   The formatter label display setting.
   * @param string $view_mode
   *   The view mode.
   * @param array $third_party_settings
   *   Any third party settings.
   * @param \Drupal\vlsuite_icon_font\VLSuiteIconFontHelper $icon_font_helper
   *   The icon font helper.
   */
  public function __construct($plugin_id, $plugin_definition, FieldDefinitionInterface $field_definition, array $settings, $label, $view_mode, array $third_party_settings, VLSuiteIconFontHelper $icon_font_helper) {
    parent::__construct($plugin_id, $plugin_definition, $field_definition, $settings, $label, $view_mode, $third_party_settings);

    $this->iconFontHelper = $icon_font_helper;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $plugin_id,
      $plugin_definition,
      $configuration['field_definition'],
      $configuration['settings'],
      $configuration['label'],
      $configuration['view_mode'],
      $configuration['third_party_settings'],
      $container->get('vlsuite_icon_font.helper')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $elements = [];

    foreach ($items as $delta => $item) {
      $view_value = $this->viewValue($item);
      $elements[$delta] = $view_value;
    }
    return $elements;
  }

  /**
   * Generate the output appropriate for one icon field item.
   *
   * @param \Drupal\Core\Field\FieldItemInterface $item
   *   One icon field item.
   *
   * @return array
   *   Build icon.
   */
  protected function viewValue(FieldItemInterface $item) {
    return $this->iconFontHelper->buildIconFontIcon($item->value);
  }

}
