# Views Node Title Selector

This module addresses a common usability issue in Drupal Views: filtering by node title using a simple text box can be inefficient and prone to typos, especially for a large number of nodes. This is particularly true for administrative dashboards where a quick and accurate search is critical.

For example, imagine an admin dashboard listing contact details for many organizations, where each organization's details are stored within a single node. Finding a specific organization by typing its full name can be a tiring task. This module provides a better solution by giving you the option to create a **select list, autocomplete field, or checkboxes filter** for node titles.

### Features

- **Context-aware:** The filter automatically detects and lists nodes from the content types already filtered in the View.
- **Multiple widgets:** Choose between a select list, autocomplete field (useful for many nodes), or checkboxes for multi-select.
- **Dynamic or frozen list:** The list of nodes can be configured to automatically include new nodes as they are created, or be "frozen" to a static list at the time of configuration.
- **Exclude specific nodes:** Administrators can exclude specific nodes from appearing in the exposed filter list.

### Usage

1. Go to the Views UI and edit an existing View or create a new one.
2. In the "Filter criteria" section, click "Add".
3. Search for "Node: Title (select/autocomplete)" and add the filter.
4. Configure the filter's options to set the widget type and other preferences.
5. Expose the filter to users by checking the "Expose this filter to visitors, to allow them to change it" box.
6. Save the View.

### Requirements

- Drupal 10 or 11
- Core `node` module
- Core `views` module

### Contribution

Bug reports and feature requests are welcome! Please use the issue queue on the project page: [link to your project page on Drupal.org].