# Voice Recorder

A powerful and user-friendly voice recording module for Drupal, enabling audio
recording directly in the browser with MP3 encoding.

This module provides a field widget for file fields that allows audio recording
through a microphone and stores it as an MP3 file. The recording process is
managed via a floating widget that appears upon clicking the "Record" button.

The recorder creates an MP3 file and sets it to the upload element using
[Recorderjs](https://github.com/mattdiamond/Recorderjs) and
[lamejs](https://github.com/zhuker/lamejs) libraries for in-browser recording
and encoding.

## Features

- Provides an element and a field widget for file fields.
- Supports both single and multiple file fields.
- Supports usage in custom forms, altering via hooks, templates overrides of
recording button and floating widget.
- Enables browser-based audio recording with fallback to default file upload.
- Configurable widget displaying: show/hide upload, elements to show on file
preview (file link with size, audio player, both).
- Full recording controls: pause, resume, and restart.
- Configurable countdown timer before recording starts.
- Supports maximum duration limits (automatically stops recording when the
limit is reached).
- Visual feedback: a recording duration display, statuses, indication of
encoding progress.
- Warns users before reloading the page during recording.
- MP3 encoding directly on the client side.
- Checks for browser compatibility.
- Graceful error handling with error messages displayed in the floating widget.
- Mobile-friendly interface.

## Requirements

- A modern browser with audio recording support (Chrome, Firefox, Safari, Edge,
etc.).
- JavaScript must be enabled.

## Installation

1. Install the module using Composer:
   ```bash
   composer require drupal/voice_recorder
   ```
2. Enable the module via the /admin/modules page or using Drush:
   ```bash
   drush en voice_recorder
   ```

## Usage

### As a Field Widget

1. Add a file field to your entity, ensuring it allows MP3 file extensions
(more extensions can be set if you want them to be uploaded)
2. Select the "Voice Recorder File" field widget for your file field
3. Configure the widget settings, including:
  - Maximum recording duration (highly recommended)
  - Countdown timer duration
  - Additional settings available in the widget configuration form
  - Custom settings adjustments via a hook (if specific customization needed)

### In Custom Forms

```php
$form['recording'] = [
  '#type' => 'voice_recorder_file',
  '#upload_validators' => [
    'FileExtension' => ['extensions' => 'mp3'],
  ],
  '#voice_recorder_settings' => [
    'initiator_field_label' => 'The label to display inside widget',
    // Max recording 1 minute, use 0 for unlimited recording.
    'max_recording_time' => 60,
    // 3 seconds countdown, use 0 for no countdown.
    'countdown_time_before_recording' => 3,
    'start_recording_label' => t('Start recording'),
    'upload_element_displaying' => 'show',
    'file_information_displaying' => 'filename_link_and_audio',
    // Other settings: VoiceFileRecorder::getVoiceRecorderDefaultSettings
  ],
  // Other properties same as in '#type' => 'managed_file'.
];
```

### Label override and translation

Each field that uses the widget can have its own set of labels.
Some labels are not yet editable through the widget configuration
form, but they can still be modified in the configuration and
translated as needed.

For example, we have a field named `field_audio_recording`
in the `Basic page` content type. It can be translated using
config translation into Ukrainian as follows:
./config/sync/uk/core.entity_form_display.node.page.default.yml
```yml
content:
  field_audio_recording:
    settings:
      start_recording_label: 'Записати'
      close_recording_label: 'Закрити запис'
      stop_recording_label: 'Зупинити запис'
      pause_recording_label: 'Пауза запису'
      resume_recording_label: 'Продовжити запис'
      restart_recording_label: 'Перезапустити запис'
      recording_for_label: 'Запис для'
```

## Contributing

- Report any bugs, feature requests, etc. in the
[issue tracker](https://www.drupal.org/project/issues/voice_recorder)
- Contribute code back to the module

## Similar modules

- [Audio Recorder Widget](https://www.drupal.org/project/audiorecorder)

## Authors

- [Volodymyr Knyshuk](https://www.drupal.org/user/3536002)
- [Justin Phelan](https://www.drupal.org/user/54285)

---

## 🇺🇦 Supporting Ukraine

This module is maintained by Ukrainian developers.
Please consider [supporting Ukraine](https://supportukrainenow.org) in their
fight for freedom and the safety of Europe.
