'use strict';

const gulp = require('gulp');
const sass = require('gulp-sass')(require('sass'));
const sassGlob = require('gulp-sass-glob');
const sourcemaps = require('gulp-sourcemaps');
const autoprefixer = require('gulp-autoprefixer');
const browserSync = require('browser-sync');
const mode = require('gulp-mode')({
  modes: ["prod", "dev"],
  default: "prod",
  verbose: false
});

// Build tasks.
function style() {
  return gulp.src('scss/**/*.scss')
    .pipe(sassGlob())
    .pipe(mode.dev(sourcemaps.init())) // Use "gulp style --dev" for sourcemaps
    .pipe(sass().on('error', sass.logError))
    .pipe(autoprefixer({
      browsers: ['last 2 versions']
    }))
    .pipe(mode.dev(sourcemaps.write()))
    .pipe(gulp.dest('css'))
    .pipe(browserSync.reload({
      stream: true
    }));
}

// Watch & Build tasks.
// Use "gulp watch --dev" for sourcemaps
function watchFiles() {
  var files = [
    'css/**/*.css',
    'js/**/*.js',
    'images/**/*',
  ];
  browserSync.init({
    proxy: "https://local.site/"
  });
  gulp.watch('./scss/**/*.scss', style);
  gulp.watch(files).on('change', browserSync.reload)
}

const watch = gulp.series(style, watchFiles);

exports.style = style;
exports.css = style;
exports.build = style;
exports.default = style;
exports.watch = watch;
