<?php

namespace Drupal\voice_recorder\Plugin\Validation\Constraint;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Validation\Attribute\Constraint;
use Symfony\Component\Validator\Constraint as SymfonyConstraint;

/**
 * File audio duration limit constraint.
 */
#[Constraint(
  id: 'VoiceRecorderFileAudioDurationLimit',
  label: new TranslatableMarkup('File Audio Duration Limit', [], ['context' => 'Validation']),
  type: 'file'
)]
class FileAudioDurationLimitConstraint extends SymfonyConstraint {

  /**
   * The message for when file audio duration limit is exceeded.
   *
   * @var string
   */
  public string $maxAudioDurationMessage = 'The file is %duration exceeding the maximum duration of %maxduration.';

  /**
   * The file audio duration limit (in seconds).
   *
   * @var int
   */
  public int $durationLimit = 0;

  /**
   * {@inheritdoc}
   */
  public function getDefaultOption(): ?string {
    return 'durationLimit';
  }

}
