<?php

namespace Drupal\voice_recorder\Plugin\Validation\Constraint;

use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\file\FileInterface;
use Drupal\file\Plugin\Validation\Constraint\BaseFileConstraintValidator;
use Drupal\voice_recorder\Utility\DurationFormatter;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\Exception\UnexpectedTypeException;

/**
 * Validates the FileAudioDurationLimitConstraint.
 */
class FileAudioDurationLimitConstraintValidator extends BaseFileConstraintValidator implements ContainerInjectionInterface {

  /**
   * Creates a new FileAudioDurationLimitConstraintValidator.
   *
   * @param \Drupal\Core\Session\AccountInterface $currentUser
   *   The current user.
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entityTypeManager
   *   The entity type manager.
   */
  public function __construct(
    protected AccountInterface $currentUser,
    protected EntityTypeManagerInterface $entityTypeManager,
  ) {}

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('current_user'),
      $container->get('entity_type.manager')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function validate(mixed $value, Constraint $constraint): void {
    // This constraint only shows information in the file help.
    // To make the validation actually work check the duration of audio using
    // the tool like james-heinrich/getid3.
    return;

    $file = $this->assertValueIsFile($value);
    if (!$constraint instanceof FileAudioDurationLimitConstraint) {
      throw new UnexpectedTypeException($constraint, FileAudioDurationLimitConstraint::class);
    }

    $durationLimit = $constraint->durationLimit;

    if ($durationLimit) {
      $duration = $this->getDuration($file);
      if ($duration > $durationLimit) {
        $this->context->addViolation($constraint->maxAudioDurationMessage, [
          '%duration' => DurationFormatter::format($duration),
          '%maxduration' => DurationFormatter::format($durationLimit),
        ]);
      }
    }
  }

  /**
   * Get audio file duration in seconds.
   *
   * @param \Drupal\file\FileInterface $file
   *   The file entity to check.
   *
   * @return float|null
   *   The duration in seconds, or NULL if duration could not be determined.
   */
  protected function getDuration(FileInterface $file): ?float {
    return NULL;
  }

}
