<?php

namespace Drupal\voice_recorder\Utility;

/**
 * Helper class for formatting duration.
 */
class DurationFormatter {

  /**
   * Format seconds to full duration with plurals.
   *
   * @param int $duration_seconds
   *   Duration in seconds.
   *
   * @return string
   *   Formatted duration string (e.g., "2 hours 30 minutes 15 seconds").
   */
  public static function format(int $duration_seconds): string {
    if ($duration_seconds <= 0) {
      return t('@count seconds', ['@count' => 0]);
    }

    $hours = floor($duration_seconds / 3600);
    $minutes = floor(($duration_seconds % 3600) / 60);
    $seconds = $duration_seconds % 60;

    $parts = [];

    if ($hours > 0) {
      $parts[] = \Drupal::translation()->formatPlural(
        $hours,
        '@count hour',
        '@count hours'
      );
    }

    if ($minutes > 0) {
      $parts[] = \Drupal::translation()->formatPlural(
        $minutes,
        '@count minute',
        '@count minutes'
      );
    }

    if ($seconds > 0 || empty($parts)) {
      $parts[] = \Drupal::translation()->formatPlural(
        $seconds,
        '@count second',
        '@count seconds'
      );
    }

    return implode(' ', $parts);
  }

}
