<?php

/**
 * @file
 * Contains Views API hooks for vote_anon module.
 */

/**
 * Implements hook_views_data().
 */
function vote_anon_views_data(): array {
  $t = \Drupal::translation();

  $data = [];

  $data['vote_anon_counts'] = [];
  $data['vote_anon_counts']['table'] = [
    'group' => $t->translate('Anonymous Vote'),
    'provider' => 'vote_anon',
    'base' => [
      'field' => 'vote_id',
      'title' => $t->translate('Vote For Anonymous'),
      'help' => $t->translate('Vote For Anonymous.'),
      'weight' => -10,
    ],
    'join' => [
      'node_field_data' => [
        'left_field' => 'nid',
        'field' => 'entity_id',
        'extra' => [
          [
            'field' => 'published',
            'value' => TRUE,
          ],
        ],
      ],
    ],
  ];

  $data['vote_anon_counts']['entity_id'] = [
    'title' => $t->translate('Vote entity ID'),
    'help' => $t->translate('Vote entity ID'),
    'relationship' => [
      'base' => 'node_field_data',
      'base field' => 'nid',
      'id' => 'standard',
      'label' => $t->translate('Entity Voting node ID'),
    ],
  ];

  $data['vote_anon_counts']['count'] = [
    'title' => $t->translate('Vote counter'),
    'help' => $t->translate('The number of times a piece of content is voted by any user.'),
    'field' => [
      'id' => 'numeric',
      'click sortable' => TRUE,
    ],
    'sort' => [
      'id' => 'groupby_numeric',
    ],
    'filter' => [
      'id' => 'numeric',
    ],
    'argument' => [
      'id' => 'numeric',
    ],
  ];

  $data['vote_anon_counts']['last_updated'] = [
    'title' => $t->translate('Time last vote'),
    'help' => $t->translate('The time a piece of content was most recently voted by any user.'),
    'field' => [
      'id' => 'date',
      'click sortable' => TRUE,
    ],
    'sort' => [
      'id' => 'date',
    ],
    'filter' => [
      'id' => 'date',
    ],
    'argument' => [
      'id' => 'date',
    ],
  ];

  return $data;
}
