# Views Reference Field Suite

This module provides new plugins and also extends functionality for the Views Reference Field module.

The main goal of the plugins is to provide more intuitive widgets to be able to configure contextual filters to the views so that a ‘Content Manager’ user has a more intuitive interface to configure the referenced view.

On the other hand, this module implements a field widget and a field formatter improved, in order to pass additional information to the @ViewsReferenceSetting plugins. Specifically, the ‘entity type’ and the ‘bundle’ where the view is being referenced are provided. In this way, a developer who wants to develop a plugin of type @ViewsReferenceSetting, can improve the user experience in the configuration form and additionally can inject information to the view at rendering time, as can be seen in the files attached to this description.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/vrfs).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/vrfs).


## Table of contents

- Requirements
- Installation
- Configuration
- Maintainers


## Requirements

  - [Views Reference Field](https://www.drupal.org/project/viewsreference)
  - [Autocomplete Deluxe](https://www.drupal.org/project/autocomplete_deluxe)


## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration

Set the widget or the different field formatters to the desired field for improved user experience.


## Maintainers

- aarnau - [aarnau](https://www.drupal.org/u/aarnau)
- Carlos Romero - [carlos-romero](https://www.drupal.org/u/carlos-romero)