# Views Vanilla JavaScript Reveal

## Overview
The **Views Vanilla JavaScript Reveal** module (machine name: `vvjr`) is a 
versatile and dynamic Views style plugin designed to render content items in 
an engaging reveal format using vanilla JavaScript. This module enhances your 
site by adding a visually appealing, interactive reveal effect to content 
displayed through Drupal Views.

## Features
- **Interactive Reveal Boxes**: Display content items with reveal animations 
  for a dynamic user experience.
- **Customizable Options**: Adjustable settings for reveal style, speed, 
  background colors, and more.
- **Responsive Design**: Built-in breakpoints to ensure the reveal adapts 
  seamlessly to different screen sizes.
- **Hover or Click Activation**: Choose whether the reveal occurs on hover 
  or click.

## Configuration
After installing and enabling the module, you can configure it through the 
Views UI:

1. **Reveal Style**: Choose the reveal animation style (e.g., Fade, Zoom, 
   Top, Right, Bottom, Left).
2. **Reveal Speed**: Set the speed for the reveal animation (e.g., 0.1 for 
   fast, 2 for slow).
3. **Background Colors**: Customize the background colors for the front and 
   revealed sides of the box.
4. **Available Breakpoints**: Select the breakpoints to ensure the reveal is 
   responsive (e.g., 576px, 768px, 992px, etc.).

## Token Support in Views Text Areas

In Views headers, footers, or empty text areas—when using *Global: Text area* or
*Global: Unfiltered text*—there is an option called **"Use replacement tokens
from the first row."**

The default Twig-style tokens (e.g., `{{ title }}` or `{{ field_image }}`)
**will not work** with the VVJR style. Instead, use the custom tokens provided
by VVJR:

**Examples:**

- `{{ title }}` → `[vvjr:title]`  
- `{{ field_image }}` → `[vvjr:field_image]`

To strip any HTML from the output, you can append `:plain` to the token:

- `[vvjr:title:plain]`

These tokens pull data from the **first row** of the View result and are
designed to work seamlessly with the VVJR rendering system.

## Example Usage
1. Create a new view or edit an existing view.
2. Under the "Format" section, select "Views Vanilla JavaScript Reveal" as 
   the style.
3. Configure the reveal style, speed, background colors, and other settings 
   as needed.
4. Save the view and see the reveal in action on the front end.

## Additional Information
- **Dependencies**: This module does not have any dependencies on other 
  contributed modules.
- **Compatibility**: Fully compatible with Drupal 10 and follows Drupal best 
  practices.

## Installation
1. Download and install the module from 
   [Drupal.org](https://www.drupal.org/project/vvjr).
2. Enable the module through the Drupal admin interface or using Drush: 
   `drush en vvjr`
3. Clear caches to ensure the new plugin is available: `drush cr`

## Troubleshooting
If you encounter any issues or have suggestions for improvements, please open 
an issue in the module's issue queue on Drupal.org.

## Maintainers
- [Alaa Haddad](https://www.drupal.org/u/flashwebcenter)

## Support
For issues, feature requests, and general support, please use the 
[issue queue](https://www.drupal.org/project/issues/vvjr).

## License
This project is licensed under the 
[GNU General Public License, version 2 or later](http://www.gnu.org/licenses/gpl-2.0.html).
