<?php

namespace Drupal\vwo;

use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Service class for VWO help functions.
 */
class VwoHelp {
  use StringTranslationTrait;

  /**
   * Get the settings updated help block content.
   *
   * @return string
   *   The help block HTML content.
   */
  public function getSettingsUpdatedHelp() {
    return '<div class="vwo-help-block vwo-help-block--settings">
      <div class="vwo-help-block__content">
        <div>
          <div class="vwo-help-block__title">New to VWO?</div>
          <div class="vwo-help-block__description">Create a free account to unlock A/B testing, heatmaps, and more. No credit card required!</div>
        </div>
        <a class="vwo-help-block__button button button--primary" target="_blank" href="https://vwo.com/free-trial?utm_source=integration_drupal&utm_medium=referral&utm_campaign=free_trial_banner&utm_content=config_screen_banner">
          Get Started for Free
        </a>
      </div>
    </div>';
  }

  /**
   * Get the report help block content.
   *
   * @return string
   *   The help block HTML content.
   */
  public function getReportHelp() {
    return '<div class="vwo-help-block vwo-help-block--dashboard">
      <div class="vwo-help-block__content">
        <div class="vwo-help-block__title">VWO Dashboard</div>
        <div class="vwo-help-block__description">Access your VWO Dashboard to view reports, analyze test results, and monitor your campaigns\' performance. From here, you can access all your reports, including A/B tests, heatmaps, and more.</div>
        <a class="vwo-help-block__dashboard-link" href="https://app.vwo.com" target="_blank">
          <span>Go to Dashboard</span>
          <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 32 32">
            <path fill="currentColor" d="M17.88 1v3.75h5.62l-9.38 9.38 3.76 3.74 9.37-9.37v5.63H31V1H17.87zm9.37 26.25H4.75V4.75h7.5V1H1v30h30V19.75h-3.75v7.5z"/>
          </svg>
        </a>
        <div class="vwo-help-block__help-text">
          Need help? Visit our <a class="vwo-help-block__help-link" href="https://help.vwo.com/hc/en-us/articles/360020538734-Integrating-VWO-With-Drupal" target="_blank">Knowledge Base</a> for guides and FAQs.
        </div>
      </div>
    </div>';
  }

}
