# WebAuthn (Passkey) Module

## About the Module
The WebAuthn (passkey) module enables passwordless authentication for Drupal using Passkeys (FIDO2/WebAuthn). It allows users to register authenticators (such as Touch ID, Face ID, YubiKeys, or Windows Hello) and log in securely without entering a password.

The module leverages the robust `web-auth/webauthn-lib` library to handle cryptographic operations, ensuring a secure and standard-compliant implementation.

## Features
-   **Passwordless Login:** Users can log in using only their passkey.
-   **Secure Registration:** Supports registration of multiple authenticators per user.
-   **Configuration Control:**
    -   **Global Toggle:** Administrators can enable or disable passkey login globally.
    -   **Role Restrictions:** Restrict passkey usage to specific user roles.
-   **Management Interface:** Users can view and delete their registered passkeys via a dedicated "Manage Passkeys" tab on their profile.
-   **Security:**
    -   **Flood Control:** Protects against brute-force attacks on registration and login endpoints.
    -   **Origin Validation:** Strictly validates the origin of authentication requests.
    -   **CSRF Protection:** Secures sensitive management actions.
    -   **AAGUID Validation:** (Optional) Restrict authenticators to specific models.

## Requirements
-   **Drupal:** ^11.2
-   **PHP:** ^8.3
-   **Library:** `web-auth/webauthn-lib` ^5.2
-   **HTTPS:** WebAuthn **requires** a secure context (HTTPS) to function. It will not work over HTTP (except for `localhost`).

## Installation
Install the module via Composer to ensure all dependencies are downloaded:

```bash
composer require drupal/wa
drush en wa
```

## Configuration

### 1. General Settings
Navigate to **Configuration > People > Passkey Settings** (`/admin/config/people/wa`).

-   **Enable Passkey Login:** Toggle this off to disable the "Sign in with Passkey" button and block all passkey API endpoints.
-   **Allowed Roles:** Select which user roles are permitted to use passkeys. If no roles are selected, all authenticated users can use passkeys.

### 2. Permissions
Configure permissions at `/admin/people/permissions`:


-   `administer all user passkey`: Allows administrators to manage (delete) passkeys for other users.

### 3. Passkey Overview
Administrators can view a list of all registered passkeys on the site by navigating to **Administration > People > Passkeys** (`/admin/people/passkeys`). This view provides details such as:
-   **User:** The owner of the passkey.
-   **Provider:** The authenticator type/provider (e.g., Touch ID, YubiKey).
-   **Created:** The date and time of registration.
-   **Last used:** The last time the passkey was used for authentication.

### 4. User Passkey Management
Users can manage their own passkeys via their user profile:
1.  Go to **My account** (`/user`).
2.  Click on the **Passkeys** tab.
3.  Here, users can:
    -   **Add Passkey:** Register a new device (Touch ID, YubiKey, etc.).
    -   **Delete:** Remove an existing passkey.

## Troubleshooting

### "Sign in with Passkey" button is missing
-   Check if the module is enabled.
-   Check if **Enable Passkey Login** is checked in the configuration.
-   Ensure you are on the default user login form.

### Rate limiting blocks requests unexpectedly
-   Flood control in this module keys on client IP for both options and verify endpoints. If you're behind a load balancer or proxy, ensure Drupal is configured for reverse proxy handling so `getClientIp()` resolves the real client IP: set `reverse_proxy` to `TRUE` and list proxy addresses/ranges in `reverse_proxy_addresses` (and trusted headers) in `settings.php`. See Drupal's guidance for reverse proxies: https://www.drupal.org/docs/getting-started/installing-drupal/using-a-load-balancer-or-reverse-proxy

### Registration/Login fails immediately
-   **HTTPS:** Ensure you are accessing the site over HTTPS. Browsers block WebAuthn API on insecure origins.
-   **Console Errors:** Check the browser's developer console for JavaScript errors.
-   **Drupal Logs:** Check **Reports > Recent log messages** for server-side errors (e.g., "Invalid Origin", "Flood control").

### "The operation either timed out or was not allowed"
-   This is a browser-level error. It often happens if the user cancels the dialog or if the device doesn't support the requested authenticator type.

### "This authenticator is not allowed for passkey login."
-   This error appears when adding a new passkey, and there is an error "Passkey registration blocked for disallowed AAGUID" in the Drupal logs if you have configured **Allowed authenticators** in the settings and the user is trying to use a restricted device.
-   **Solution:** Go to `/admin/config/people/wa` and ensure the authenticator type (AAGUID) is checked.
-   **Firefox/Chrome/iCloud:** If using a software authenticator (like Touch ID on Mac via Chrome/Firefox), ensure **"Generic / Software Authenticator"** is checked.

### Clock Synchronization
-   WebAuthn relies on time-sensitive challenges. Ensure your server's clock is synchronized (NTP).
