<?php

namespace Drupal\wa\Plugin\views\filter;

use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\wa\Service\PasskeyLabeler;
use Drupal\views\Plugin\views\filter\InOperator;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Filters passkeys by provider label (mapped from AAGUID).
 *
 * @ViewsFilter("wa_passkey_provider")
 */
class PasskeyProvider extends InOperator implements ContainerFactoryPluginInterface {

  /**
   * Passkey labeler service.
   *
   * @var \Drupal\wa\Service\PasskeyLabeler
   */
  protected $passkeyLabeler;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('wa.passkey_labeler')
    );
  }

  /**
   * Constructs the filter plugin.
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, PasskeyLabeler $passkey_labeler) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->passkeyLabeler = $passkey_labeler;
    $this->valueTitle = $this->t('Provider');
  }

  /**
   * {@inheritdoc}
   */
  protected function defineOptions() {
    $options = parent::defineOptions();
    $options['exposed'] = ['default' => TRUE];
    $options['expose'] = [
      'default' => [
        'operator_id' => 'provider_op',
        'label' => $this->t('Provider'),
        'identifier' => 'provider',
        'required' => FALSE,
        'multiple' => TRUE,
        'reduce' => FALSE,
        'use_operator' => FALSE,
      ],
    ];
    return $options;
  }

  /**
   * {@inheritdoc}
   */
  public function getValueOptions() {
    if (!isset($this->valueOptions)) {
      $this->valueOptions = $this->passkeyLabeler->getProviderOptions();
    }
    return $this->valueOptions;
  }

  /**
   * {@inheritdoc}
   */
  public function query() {
    $selected = array_filter((array) $this->value, 'strlen');
    if (!$selected) {
      return;
    }

    $this->ensureMyTable();
    $this->query->addWhere(
      $this->options['group'],
      "$this->tableAlias.aaguid",
      $selected,
      'IN'
    );
  }

}
