<?php

namespace Drupal\wayback_filter\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Wayback Filter settings for this site.
 */
class WaybackFilterSettingsForm extends ConfigFormBase {

  /**
  * {@inheritdoc}
  */
  protected function getEditableConfigNames() {
      return ['wayback_filter.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'wayback_filter_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('wayback_filter.settings');
    // v($config,0,'config');

      $form['waybacklink_icon'] = [
        '#type' => 'textfield',
        '#size' => 20,
        '#title' => $this->t('Icon or text for the Wayback link'),
        '#default_value' => $config->get('waybacklink_icon') ?? '🏛️',
        '#description' => $this->t('Enter an emoji, a Unicode character or some text.<br />We recommend <a href="@classical_building">🏛️</a> (classical building), <a href="@floppy">💾</a> (floppy disk), <a href = "@circlearrow">⟲</a> (circle arrow) or simply the text <em>[Wayback link]</em>.<br />You can find emojis at <a href = "@emojipedia">Emojipedia</a>', ['@classical_building' => 'https://emojipedia.org/search/?q=building', '@floppy' => 'https://emojipedia.org/search/?q=floppy', '@circlearrow' => 'https://www.compart.com/en/unicode/U+27F2', '@emojipedia' => 'https://emojipedia.org/']),
      ];

      $form['waybacklink_title'] = [
        '#type' => 'textfield',
        '#size' => 40,
        '#title' => $this->t('Link title for the Wayback link'),
        '#default_value' => $config->get('waybacklink_title') ?? $this->t('Click to see an archived version of the destination page.'),
        '#description' => $this->t('This is what desktop users get to read when their cursor hovers over the Wayback link.'),
      ];

      $form['waybacklink_start'] = [
        '#type' => 'number',
        '#title' => $this->t('Place Wayback links on nodes older than...'),
        '#min' => 0,
        '#max' => 30,
        '#field_suffix' => 'years',
        '#default_value' => $config->get('waybacklink_start') ?? 3,
        '#description' => $this->t('Nodes older than this many years will get a trailing Wayback link.'),
      ];

      $form['waybacklink_preview'] = [
        '#markup' => '<div class="form-item__label">' . $this->t('Preview of a link with a trailing Wayback link') . '</div> <a href = "https://vertikal.dk/linkrot-solved-problem">Linkrot is a solved problem</a> <a href = "https://web.archive.org/web/20210701194421/https://vertikal.dk/linkrot-solved-problem" title = "waybacklink_title" class = "wayback-link" id = "waybacklink_preview">[Wayback link]</a>',
        '#allowed_tags' => ['label', 'a', 'div'],
      ];

      $form['waybacklink_help'] = [
        '#markup' => '<br><br><div class="form-item__label">' . $this->t('Advanced help') . '</div>' . $this->t('Most people will be able to see emojis and Unicode characters. Even if they differ a bit between platforms. Only desktop users will be able to see the link title and only when their cursor hovers over the Wayback link. The Wayback link can be styled by adding styles to the CSS class <em>wayback-link</em> (i.e <em>.wayback-link a {font-size: 0.8rem; color: red;}</em> somewhere in your stylesheet will make the Wayback link small and red.)<br />If you wish to paste actual emojis into any of the above fields, you better make sure that your Drupal database is <a href="@utf8mb4">utf8mb4</a>. Seeing as you are running this on a Drupal 8+, it probably is.<br><br>', array('@utf8mb4' => 'https://www.eversql.com/mysql-utf8-vs-utf8mb4-whats-the-difference-between-utf8-and-utf8mb4/')),
        '#allowed_tags' => ['label', 'a', 'br', 'div', 'em'],
      ];

      $form['nicetoknow'] = [
        '#markup' => $this->t('<strong>Nice to know</strong><br>The Wayback Filter works only in view mode <em>full</em>. The filter looks at the created date of the node, and tries to find the closest match at archive.org. That is: if your node was created on christmas morning 2011, it will link to the christmas morning 2011 versions of the link destination pages. Do they exist? Often they do. Give or take some days or weeks. If you want to be absolutely sure that archived versions of your link destination exists, use <a href = "https://web.archive.org/">the relevant browser extension at the Wayback Machine</a> (look under <em>Tools</em>) to produce an 1-click archived version.'),
        '#allowed_tags' => ['label', 'a', 'em', 'br'],
      ];

      $form['warning'] = [
        '#markup' => '<h3>' . $this->t('Note: Most people are satisfied with <a href = "/admin/config/content/formats">adding Wayback Links to text formats using the Configure-button</a>') . '</h3>' .  $this->t('You should probably do it right after you have saved this form.<br>Yet...If you want to add Wayback Links to a host of different link fields, go ahead:'),
        '#allowed_tags' => ['label', 'a', 'h3'],
      ];

    $form['field_link'] = [
        '#type' => 'textarea',
        '#title' => $this->t('Experimental: Field Names'),
        '#default_value' => $config->get('field_link') ? implode("\n", $config->get('field_link')) : '',
        '#description' => $this->t('Enter the machine names of the fields to apply the filter. One per line. I.e.<br><em>field_link</em><br><em>field_url</em><br>- For every <a href = "/admin/structure/types">content type</a> you can press <em>Manage fields</em> to get a list of <em>Machine names</em>. Yes, these are the names you should use here.'),
      ];

    return parent::buildForm($form, $form_state);
  }

    /**
    * {@inheritdoc}
    */
    public function submitForm(array &$form, FormStateInterface $form_state) {
        // Retrieve the existing configuration object.
        $config = $this->config('wayback_filter.settings');

        // Save the field_link settings.
        $fields = array_filter(preg_split('/\r\n|\r|\n/', $form_state->getValue('field_link')));
        $config->set('field_link', $fields);

        // Save the additional settings.
        $config->set('waybacklink_icon', $form_state->getValue('waybacklink_icon'))
            ->set('waybacklink_title', $form_state->getValue('waybacklink_title'))
            ->set('you fucker', $form_state->getValue('you fucker'))
            ->set('waybacklink_start', $form_state->getValue('waybacklink_start'));

        // Write the settings to the configuration storage.
        $config->save();

        // Don't forget to call the parent submitForm method which will handle redirection etc.
        parent::submitForm($form, $form_state);
    }


}
