<?php
/**
 * @file
 * Admin form functions.
 */

/**
 * Configuration form.
 *
 * @ingroup forms
 * @see system_settings_form()
 */
function wayf_dk_login__settings_form() {

  $idp_metadata_default = wayf_dk_login__get_ipd_metadata('test');

  $form['tabs'] = array(
    '#type' => 'vertical_tabs',
  );

  $form['idp'] = array(
    '#type' => 'fieldset',
    '#title' => t('WAYF bridge'),
    '#group' => 'tabs',
  );

  $form['idp']['wayf_dk_login_mode'] = array(
    '#type' => 'select',
    '#title' => t('Service mode'),
    '#options' => array(
      'test' => t('Test'),
      'qa' => t('Quality assurance'),
      'production' => t('Production'),
    ),
    '#default_value' => variable_get('wayf_dk_login_mode', 'test'),
    '#ajax' => array(
      'callback' => 'wayf_dk_login__ajax_callback',
      'wrapper'  => 'idp-wrapper',
      'method'   => 'replace',
      'effect'   => 'fade',
    ),
  );

  $form['idp']['container'] = array(
    '#type' => 'container',
    '#prefix' => '<div id="idp-wrapper">',
    '#suffix' => '</div>',
  );

  $form['idp']['container']['wayf_dk_login_idp_sso'] = array(
    '#type' => 'hidden',
    '#default_value' => variable_get('wayf_dk_login_idp_sso', $idp_metadata_default->location),
  );

  $form['idp']['container']['wayf_dk_login_idp_sso_markup'] = array(
    '#type' => 'markup',
    '#prefix' => '<b>' . t('Single signon URL') . '</b> : ',
    '#markup' => variable_get('wayf_dk_login_idp_sso', $idp_metadata_default->location),
  );

  $form['idp']['container']['wayf_dk_login_idp_certificate'] = array(
    '#type' => 'hidden',
    '#default_value' => variable_get('wayf_dk_login_idp_certificate', $idp_metadata_default->cert),
  );

  $form['idp']['container']['wayf_dk_login_idp_certificate_markup'] = array(
    '#type' => 'markup',
    '#prefix' => '<br/><b>' . t('Certificate') . '</b><br/><div style="width:700px;word-break:break-all;font-size:0.8em;">',
    '#markup' => variable_get('wayf_dk_login_idp_certificate', $idp_metadata_default->cert),
    '#suffix' => '</div>',
  );

  $form['sp'] = array(
    '#type' => 'fieldset',
    '#title' => t('Service provider'),
    '#group' => 'tabs',
  );

  $form['sp']['wayf_dk_login_sp_entityid'] = array(
    '#type' => 'textfield',
    '#title' => t('Connection ID'),
    '#default_value' => variable_get('wayf_dk_login_sp_entityid', ''),
    '#description' => t('EntityID used for the service.'),
  );

  $form['sp']['wayf_dk_login_sp_endpoint'] = array(
    '#type' => 'textfield',
    '#title' => t('AssertionConsumerService:0:Location'),
    '#default_value' => variable_get('wayf_dk_login_sp_endpoint', ''),
    '#description' => t('Endpoint URL for the service.'),
  );

  $form['sp']['wayf_dk_login_sp_key'] = array(
    '#type' => 'textarea',
    '#title' => t('Private key'),
    '#default_value' => variable_get('wayf_dk_login_sp_key', ''),
    '#description' => t('Private key, base64 PEM formatted. The private key should start with -----BEGIN RSA PRIVATE KEY----- and end with -----END RSA PRIVATE KEY-----'),
  );

  $form['fields'] = array(
    '#type' => 'fieldset',
    '#title' => t('Field mappings'),
    '#group' => 'tabs',
    '#description' => '<p>' . t('Notice: only textfields can be assigned attributes
      released from WAYF and currently only singular attributes are supported.
      The email address attribute are mapped to user->mail by default.') . '</p>',
  );

  $form['fields']['wayf_dk_login_field_mapping'] = array('#tree' => TRUE);

  $fields_info = field_info_instances('user', 'user');
  $wayf_dk_login_field_mapping = variable_get('wayf_dk_login_field_mapping', array());
  foreach ($fields_info as $field_name => $field) {
    $field_info = field_info_field($field_name);
    if ($field_info['type'] == 'text') {
      $form['fields']['wayf_dk_login_field_mapping'][$field_name] = array(
        '#type' => 'select',
        '#options' => wayf_dk_login__wayf_attributes(),
        '#title' => check_plain($field['label']),
        '#default_value' => empty($wayf_dk_login_field_mapping[$field_name]) ? '' : $wayf_dk_login_field_mapping[$field_name],
      );
    }
  }

  $form['user'] = array(
    '#type' => 'fieldset',
    '#title' => t('User mappings'),
    '#group' => 'tabs',
  );

  $form['user']['local'] = array(
    '#type' => 'fieldset',
    '#title' => t('Local users'),
    '#description' => '<p>' . t('eduPersonPrincipalName is the The "NetID" of the person for the purposes
      of inter-institutional authentication. It is represented in the form "user@scope" where
      scope defines a local security domain. When setting a local scope users will be mapped by
      their username alone ( the part before @scope ).') . '</p>',
  );

  $form['user']['local']['wayf_dk_login_user_localscope'] = array(
    '#type' => 'textfield',
    '#title' => t('Local security domain (scope)'),
    '#default_value' => variable_get('wayf_dk_login_user_localscope', ''),
    '#description' => t('Users with this security domain are treated as local, only the part before "@" is used.'),
  );

  $form['user']['scoped'] = array(
    '#type' => 'fieldset',
    '#title' => t('Scoped users'),
  );

  $form['user']['scoped']['wayf_dk_login_user_autocreate'] = array(
    '#type' => 'checkbox',
    '#title' => t('Autocreate scoped users'),
    '#default_value' => variable_get('wayf_dk_login_user_autocreate', FALSE),
    '#description' => t('Autocreate users authenticated by WAYF. Users are created with eduPersonPrincipalName as name.'),
  );

  $form['display'] = array(
    '#type' => 'fieldset',
    '#title' => t('Display settings'),
    '#group' => 'tabs',
  );

  $form['display']['wayf_dk_login_loginform'] = array(
    '#type' => 'checkbox',
    '#title' => t('Add WAYF login button to the standard login form'),
    '#default_value' => variable_get('wayf_dk_login_loginform', FALSE),
  );

  $icon_path = drupal_get_path('module', 'wayf_dk_login') . '/icons/';

  $icons = array();
  foreach (wayf_dk_login__icons() as $icon) {
    $icons[$icon] = theme('image', array('path' => $icon_path . $icon, 'attributes' => array('class' => 'wayf_dk_login-be-img')));
  }

  $form['display']['wayf_dk_login_icon'] = array(
    '#type' => 'radios',
    '#title' => t('Icon'),
    '#description' => t('Select icon.'),
    '#options' => $icons,
    '#default_value' => variable_get('wayf_dk_login_icon', 'UK_01.png'),
  );

  $form['#attached']['css'] = array(drupal_get_path('module', 'wayf_dk_login') . '/admin.css');

  return system_settings_form($form);
}

/**
 * Function wayf_dk_login__wayf_attributes returns list of WAYF attributes.
 *
 * @return [array]
 *   list of singular attributes
 */
function wayf_dk_login__wayf_attributes() {

  $attributes = array(
    '' => 'Not mapped',
    'urn:oid:2.5.4.4'  => t('Last name'),
    'urn:oid:2.5.4.42' => t('First name'),
    'urn:oid:2.5.4.3'  => t('Nickname'),
    'urn:oid:2.5.4.10' => t('Organisation nickname'),
    'urn:oid:1.3.6.1.4.1.5923.1.1.1.5' => t('Primary user affiliation'),
  );

  return $attributes;

}

/**
 * Function wayf_dk_login__ajax_callback.
 *
 * @param [array] $form
 *   FAPI form array
 * @param [array] $form_state
 *   current form state
 *
 * @return [array]
 *   the form element
 */
function wayf_dk_login__ajax_callback($form, &$form_state) {

  $idp_metadata = wayf_dk_login__get_ipd_metadata($form_state['values']['wayf_dk_login_mode']);

  $form['idp']['container']['wayf_dk_login_idp_sso']['#value'] = $idp_metadata->location;
  $form['idp']['container']['wayf_dk_login_idp_sso_markup']['#markup'] = $idp_metadata->location;

  $form['idp']['container']['wayf_dk_login_idp_certificate']['#value'] = $idp_metadata->cert;
  $form['idp']['container']['wayf_dk_login_idp_certificate_markup']['#markup'] = $idp_metadata->cert;

  return $form['idp']['container'];
}
