/**
 * @file
 */

(function ($, Drupal, drupalSettings) {

    'use strict';

    /**
     * Registers behaviours related to Bynder search view widget.
     */
    Drupal.behaviors.WebdamSearchView = {
        attach: function (context) {
          $(once('webdam-compactview', '#webdam-compactview', context)).each(function() {
            BynderCompactView.open({
              mode: drupalSettings.webdam.compactviewMode,
              defaultDomain: drupalSettings.webdam.domain,
              assetTypes: drupalSettings.webdam.types,
              container:  this,
              portal: {
                editable: false,
                url: drupalSettings.webdam.domain
              },
              container: this,
              onSuccess: function(assets, AdditionalInfo) {
                var selectedValues = [];

                // Simplify the data structure, only keep what we need.
                assets.forEach(function(asset) {
                  // Alert the user that the selection does not have a thumbnail.
                  if (asset.type === 'DOCUMENT' && !asset.originalUrl) {
                    alert(Drupal.t('The document "@name" is not public. Please mark the original as public.',{'@name': asset.name}));
                    return;
                  }
                  selectedValues.push({
                    'id': asset.databaseId,
                    'type': asset.type,
                    'name': asset.name
                  });

                  // If there are no assets, do not submit the form.
                  if (selectedValues.length === 0) {
                    return;
                  }

                  if (AdditionalInfo.selectedFile !== undefined) {
                    selectedValues[0].fileUrl = AdditionalInfo.selectedFile.url;
                  }
                });

                // Append the selected assets ids to the webdam_selection hidden
                // input field, separated by a comma.
                var webdamSelection = $('input[name=webdam_selection]')[0];
                webdamSelection.value = JSON.stringify(selectedValues);

                // Trigger entity browser submit button click.
                $('.is-entity-browser-submit').click();
              }
            });
          });
        }
    };

}(jQuery, Drupal, drupalSettings));
