<?php

namespace Drupal\webdam\Exception;

use Drupal\Core\Url;

/**
 * Exception indicating that the selected bundle does not exist.
 */
class UnableToConnectException extends WebdamException {

  /**
   * Constructs UnableToConnectException.
   */
  public function __construct() {
    $log_message = 'Unable to connect to Webdam. Check if the  <a target="_blank" href=":url">configuration is set properly</a> or contact <a href=":support">support</a>.';
    $log_message_args = [
      ':url' => Url::fromRoute('webdam.configuration_form')->toString(),
      ':support' => 'mailto:support@getwebdam.com',
    ];
    $admin_message = $this->t($log_message, $log_message_args);
    $message = $this->t(
      'Unable to connect to Webdam. Please contact the site administrator.'
    );
    parent::__construct(
      $message,
      $admin_message,
      $log_message,
      $log_message_args
    );
  }

}
