<?php

namespace Drupal\webdam\Plugin\Action;

use Drupal\webdam\Plugin\Field\FieldType\WebdamMetadataItem;
use Drupal\Core\Access\AccessResult;
use Drupal\Core\Action\Plugin\Action\EntityActionBase;
use Drupal\Core\Session\AccountInterface;

/**
 * Updates the WebDAM metadata.
 *
 * @Action(
 *   id = "webdam_metadata",
 *   action_label = @Translation("Update WebDAM metadata"),
 *   type = "media"
 * )
 */
class UpdateMetadataAction extends EntityActionBase {

  /**
   * {@inheritdoc}
   */
  public function execute($entity = NULL) {
    $entity->getSource()->ensureMetadata($entity, TRUE);
  }

  /**
   * {@inheritdoc}
   */
  public function access($object, AccountInterface $account = NULL, $return_as_object = FALSE) {
    if (!$object->hasField(WebdamMetadataItem::METADATA_FIELD_NAME) || $object->get(WebdamMetadataItem::METADATA_FIELD_NAME)->getFieldDefinition()->getType() !== 'webdam_metadata') {
      return $return_as_object ? AccessResult::forbidden() : FALSE;
    }

    return $return_as_object ? AccessResult::allowed() : TRUE;
  }

}
