<?php

namespace Drupal\webdam\Plugin\Field\FieldType;

use Drupal\Core\Field\FieldItemBase;
use Drupal\Core\Field\FieldStorageDefinitionInterface;
use Drupal\Core\TypedData\DataDefinition;

/**
 * Plugin implementation of the 'webdam_metadata' field type.
 *
 * @FieldType(
 *   id = "webdam_metadata",
 *   label = @Translation("Webdam metadata"),
 *   description = @Translation("This field stores a JSON object that describes metadata fetched from Webdam."),
 *   category = @Translation("Webdam"),
 *   default_widget = "webdam_metadata",
 *   default_formatter = "webdam_metadata",
 *   no_ui = TRUE,
 * )
 */
class WebdamMetadataItem extends FieldItemBase {

  /**
   * The Webdam metadata field name.
   */
  const METADATA_FIELD_NAME = 'webdam_metadata';

  /**
   * {@inheritdoc}
   */
  public static function propertyDefinitions(FieldStorageDefinitionInterface $field_definition) {
    $properties['value'] = DataDefinition::create('string')->setLabel(t('JSON Value'));
    return $properties;
  }

  /**
   * {@inheritdoc}
   */
  public static function schema(FieldStorageDefinitionInterface $field_definition) {
    $schema['columns']['value']['type'] = 'text';
    $schema['columns']['value']['size'] = 'normal';

    return $schema;
  }

  /**
   * {@inheritdoc}
   */
  public function isEmpty() {
    return $this->value === NULL || $this->value === '';
  }

}
