<?php

namespace Drupal\webdam;

/**
 * Provides methods to manage the WebDAM module.
 */
interface WebdamServiceInterface {

  /**
   * Returns the WebDAM media types.
   *
   * @return \Drupal\media\MediaTypeInterface[]
   *   A list of WebDAM media types.
   */
  public function getWebdamMediaTypes();

  /**
   * Updates metadata of the next N media entities starting at the minimum ID.
   *
   * @param string|null $minimum_id
   *   (optional) The minimum media entity ID to query items for.
   * @param int $limit
   *   (optional) The number of items to update per run.
   *
   * @return array
   *   Empty array if updates are not possible. Otherwise, array with the keys:
   *     - updated (a list of updated media entities keyed by the media ID)
   *     - skipped (a list of skipped media entities keyed by the media ID)
   *     - total (the total count of processed media entities)
   *     - max_id (the maximum media entity ID that was last processed)
   */
  public function updateMetadataLastMediaEntities($minimum_id = NULL, $limit = WebdamService::MAX_ITEMS);

  /**
   * Updates a set of media entities based on the remote metadata information.
   *
   * @param \Drupal\media\MediaInterface[] $webdam_media_entities
   *   A list of media entities with a WebDAM source, keyed by the WebDAM ID,
   *   updates entities are removed from the list.
   *
   * @return \Drupal\media\MediaInterface[]
   *   A list of updated media entities.
   */
  public function updateMediaEntities(array &$webdam_media_entities);

}
