<?php

namespace Drupal\webform_composite_sortable\Plugin\WebformElement;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Render\Element;
use Drupal\webform\Plugin\WebformElement\WebformCompositeBase;

/**
 * Sortable composite base element with draggable sub-elements.
 */
class SortableCompositeBase extends WebformCompositeBase {

  /**
   * {@inheritdoc}
   */
  protected function defineDefaultProperties() {
    $properties = parent::defineDefaultProperties();
    $composite_elements = $this->getCompositeElements();
    foreach ($composite_elements as $composite_key => $composite_element) {
      $properties[$composite_key . '__weight'] = 0;
    }
    return $properties;
  }

  /**
   * {@inheritdoc}
   */
  protected function buildCompositeElementsTable(array $form, FormStateInterface $form_state) {
    $table = parent::buildCompositeElementsTable($form, $form_state);

    // Get element properties from form state.
    $element_properties = $form_state->get('element_properties') ?: [];
    $composite_elements = $this->getCompositeElements();

    // Add weight column to header.
    $table['#header']['weight'] = $this->t('Weight');

    // Add tabledrag.
    $table['#tabledrag'] = [
      [
        'action' => 'order',
        'relationship' => 'sibling',
        'group' => 'table-sort-weight',
      ],
    ];

    // Add weight field to each row.
    $weight = 0;
    foreach ($composite_elements as $composite_key => $composite_element) {
      $table[$composite_key]['weight'] = [
        'data' => [
          $composite_key . '__weight' => [
            '#type' => 'weight',
            '#title' => $this->t('Weight'),
            '#title_display' => 'invisible',
            '#attributes' => ['class' => ['table-sort-weight']],
          ],
        ],
      ];

      $table[$composite_key]['#weight'] = $element_properties[$composite_key . '__weight'] ?? $weight;
      $table[$composite_key]['#attributes']['class'][] = 'draggable';

      $weight++;
    }

    // Sort rows by weight.
    Element::children($table, TRUE);

    return $table;
  }

}
