<?php

namespace Drupal\webform_attachments\Plugin\EmailAdjuster;

use Drupal\Core\Access\AccessResult;
use Drupal\symfony_mailer\EmailInterface;
use Drupal\symfony_mailer\Processor\EmailAdjusterBase;

/**
 * Defines the Webform Attachment access Email Adjuster.
 *
 * This plugin allows private files uploaded through webforms to be attached
 * to emails. It addresses the issue where Symfony Mailer blocks private files
 * unless explicitly authorized.
 *
 * Proposed solution from:
 * https://www.drupal.org/project/webform/issues/3532279#comment-16184036
 *
 * @EmailAdjuster(
 *   id = "webform_attachment_access",
 *   label = @Translation("Webform Attachment Access"),
 *   description = @Translation("Grants attachment access to private files for webform emails."),
 *   automatic = TRUE,
 *   weight = 100,
 * )
 */
class WebformAttachmentAdjuster extends EmailAdjusterBase {

  /**
   * {@inheritdoc}
   */
  public function postRender(EmailInterface $email): void {
    $webform_id_header = $email->getHeaders()->get('X-Drupal-Webform-ID');
    if (!$webform_id_header) {
      return;
    }
    $webform_id = $webform_id_header->getBody();
    if (!empty($webform_id)) {
      foreach ($email->getAttachments() as $attachment) {
        $attachment->setAccess(AccessResult::allowed());
      }
    }
  }

}