# Webform Error Field

[![Drupal](https://img.shields.io/badge/Drupal-10.3%2B%20%7C%2011.x-blue.svg)](https://www.drupal.org)
![License](https://img.shields.io/badge/license-GPL--2.0%2B-green.svg)

A Drupal module that provides a custom webform element **Validation Message** for displaying dynamic validation messages. Perfect for creating user-friendly forms validation summaries with AJAX.

## ✨ Features

- 🎯 **Validation Message - Webform Element** - New `webform_validation_message` element type
- 🔄 **Dynamic Display** - Shows/hides based on form validation state
- 🎨 **Themeable** - Custom Twig template for easy styling
- 📦 **Zero Dependencies** - Only requires Webform module

## 📋 Requirements

- Drupal: `^10.3 || ^11`
- PHP: `^8.3`
- Webform module

## 🚀 Installation via Composer

```bash
composer require drupal/webform_error_field
drush en webform_error_field -y
```

## 📖 Usage

### Adding a Validation Message Element

1. Create or edit a webform
2. Add a new element
3. Select **"Validation Message"** from the element types
4. Configure your message in Validation message (CKEditor field)

## 🎨 Theming

The module provides a custom template that you can override:

**Template:** `webform-element-validation-message.html.twig`

**Override in your theme:**

```twig
{#
/**
 * @file
 * Theme implementation for webform validation message element.
 *
 * Available variables:
 * - element: The form element
 * - message: Validation message
 * - attributes: HTML attributes
 */
#}
{% if element['#validation_message'] %}
  <div {{ attributes.addClass('webform-validation-message', 'alert', 'alert-danger') }}>
    {{ element['#validation_message']|raw }}
  </div>
{% endif %}

```

## 🤝 Contributing

Contributions are welcome! Please follow these guidelines:

1. **Fork** the repository
2. **Create** a feature branch: `git checkout -b feature/amazing-feature`
3. **Commit** your changes: `git commit -m 'Add amazing feature'`
4. **Push** to branch: `git push origin feature/amazing-feature`
5. **Open** a Pull Request

## 📝 Changelog

### 1.0.0 (2025-10-19)

- ✨ Initial release
- ✅ Custom validation message element
- ✅ OOP hook implementation with Drupal 10.3+ support
- ✅ Themeable templates
- ✅ Full type safety

## 🐛 Known Issues

No known issues at this time. Please [report bugs](https://www.drupal.org/project/issues/webform_error_field) if you find any.

## 📚 Resources

- [Drupal.org Project Page](https://www.drupal.org/project/webform_error_field)
- [Issue Queue](https://www.drupal.org/project/issues/webform_error_field)
- [Webform Documentation](https://www.drupal.org/docs/contributed-modules/webform)

## 📄 License

This project is licensed under the GPL-2.0+ License

## 👏 Credits

**Maintainer:** [Krystian Brzoza](https://www.drupal.org/u/krystianbrzoza)

**Inspired by:**
- Drupal Webform module
- Modern PHP and Drupal best practices
- Community feedback and contributions

---

**Made with ❤️ for the Drupal Community**

*Star ⭐ this project if you find it useful!*
