<?php

declare(strict_types=1);

namespace Drupal\webform_error_field\Element;

use Drupal\Core\Render\Element\RenderElementBase;

/**
 * Provides a render element for validation message.
 *
 * @FormElement("webform_validation_message")
 */
class WebformValidationMessage extends RenderElementBase {

  /**
   * {@inheritdoc}
   */
  public function getInfo(): array {
    return [
      '#theme' => 'webform_element_validation_message',
      '#validation_message' => '',
      '#attributes' => [],
    ];
  }

}
