# Webform GoHighLevel Integration

## Description

The Webform GoHighLevel Integration module allows you to seamlessly send webform submissions from your Drupal site to the GoHighLevel CRM. With this module, you can map webform fields to GoHighLevel fields and apply both static and dynamic tags for effective customer relationship management.

## Features

- Integrates GoHighLevel API with Drupal Webforms.
- Configurable field mappings per webform via the Webform handler settings.
- Apply a static tag to all submissions from a specific form.
- **Dynamically tag contacts based on user selections in the webform.**
- Supports sending webform data securely to GoHighLevel.
- Fully customizable for unique business needs.

## Requirements

- Drupal 10 or 11.
- The [Webform](https://www.drupal.org/project/webform) module must be installed and enabled.
- A valid GoHighLevel API key.

## Installation

1.  Download and install the module:
    -   Place the `webform_gohighlevel` folder in the `modules/custom/` directory of your Drupal installation.
    -   Enable the module via the Extend page in Drupal or using Drush:
        ```bash
        drush en webform_gohighlevel
        ```

2.  Configure permissions:
    -   Navigate to **People > Permissions** and assign appropriate permissions for managing and using the module.

## Configuration

1.  **Add the Webform Handler**:
    -   Go to any Webform on your site.
    -   Click on **Settings > Emails/Handlers**.
    -   Click **+ Add handler** and select the **GoHighLevel Handler**.

2.  **Configure the Handler**:
    In the GoHighLevel Handler Settings, you'll see several options:

    -   **API Key**: Ensure your GoHighLevel API key is entered here.
    -   **Custom Tag**: Enter a static tag that will be applied to **every** submission from this form (e.g., "website-contact"). This is great for general categorization.
    -   **Select Tag Field**: (Optional) Select a field from your webform (like a dropdown or radio button). The user's selection for that field will be added as a **second, dynamic tag**. For example, if a user selects "Plumbing" from a "Service Needed" field, they will be tagged with "Plumbing".
    -   **Source**: Define a static source (e.g., "contact-form") or leave it to be populated by a specific field in your webform.
    -   **Field Mappings**: Map your webform fields (First Name, Email, etc.) to the corresponding GoHighLevel contact fields.

    -   Save the handler configuration.

3.  **Testing the Integration**:
    -   Submit the webform to ensure data is successfully sent to GoHighLevel.
    -   Check your GoHighLevel CRM to verify the submission and see the new tags!

## Troubleshooting

- Ensure the GoHighLevel API key is correct.
- Verify that the required Webform fields are mapped correctly.
- Check the Drupal logs (**Reports > Recent Log Messages**) for any API errors.

## Maintainers

- Gary Pratten (mylocaltrades) ([https://www.drupal.org/u/mylocaltrades](https://www.drupal.org/u/mylocaltrades))

Contributions, feature requests, and bug reports are welcome. Please submit them via the [issue queue](https://www.drupal.org/project/issues/webform_gohighlevel).