# Webform Google Form

Provides a webform handler to post submission values to a Google form based on a
configured mapping between webform element keys and Google Form entry IDs. It
supports primitive data types as well as multiple values and “other” values.

The module currently does not support composite elements or token replacements
in values. It is not currently as robust as the built-in Remote Post Handler,
but that does not support the element mapping required for Google Forms.

## Configuration

1. Visit the “Emails/Handlers” page of a Webform.
2. Press the “+ Add handler” button.
3. Press the “Add handler” button in the row described by the “Google form” handler.
4. Provide the Google Form entry ID for element keys you want to submit. Empty
   mappings will be ignored. To find the entry IDs, go to the Google Form edit
   user interface, and click “Pre-fill form” in the options menu. Then fill out,
   the form and press the “Get link” button and copy the URL. The URL will contain
   the entry IDs as query parameters. This is not ideal, but it is the easiest
   way to find the entry IDs.
5. Provide the Google form submission URL. This will start with the following
   string `https://docs.google.com/forms/d/e/`, and end in `/formResponse`. It
   should be the URL from the link above, but replace `viewform` with `formResponse`,
   and remove the query parameters.
6. Press the “Save” button.

## Troubleshooting

There may be elements that do not work yet. Any exception will be logged, but
usually these are HTML responses with 400 Status Code response from Google. Try
removing the mapping from elements until it works.
