<?php

namespace Drupal\Tests\webform_googleform\Functional\Handler;

use Drupal\Component\Utility\Random;
use Drupal\Core\Config\FileStorage;
use Drupal\Tests\webform\Functional\WebformBrowserTestBase;

/**
 * Tests the webfom google form handler.
 *
 * @group webform_googleform
 */
class GoogleFormHandlerTest extends WebformBrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'webform',
    'webform_ui',
    'webform_googleform',
  ];

  /**
   * {@inheritdoc}
   */
  protected static $testWebforms = ['test_google_form_handler'];

  /**
   * {@inheritdoc}
   */
  protected function loadWebform($id) {
    $storage = \Drupal::entityTypeManager()->getStorage('webform');
    if ($webform = $storage->load($id)) {
      return $webform;
    }

    $config_name = 'webform.webform.' . $id;
    $config_directory = __DIR__ . '/../../../fixtures/';

    if (!file_exists("$config_directory/$config_name.yml")) {
      throw new \Exception(sprintf('Webform %s does not exist in %s', $config_name, $config_directory));
    }

    $file_storage = new FileStorage($config_directory);
    $values = $file_storage->read($config_name);
    $webform = $storage->create($values);
    $webform->save();
    return $webform;
  }

  /**
   * Tests adding a handler to existing web form.
   */
  public function testAddHandler(): void {
    $this->drupalLogin($this->rootUser);

    // Create a close approximation of a google form id.
    $random = new Random();
    $form_id = $random->name(56);

    $edit = [
      'label' => 'Google Form',
      'handler_id' => 'google_form',
      'settings[elements][email_address_confirm]' => 'emailAddress',
      'settings[elements][a_dropdown]' => 'entry.996111207',
      'settings[elements][a_multiple_choice]' => 'entry.1797827130',
      'settings[elements][choose_one_thing]' => 'entry.579741287',
      'settings[url]' => 'https://docs.google.com/forms/d/e/' . $form_id . '/formResponse',
    ];

    $this->drupalGet('admin/structure/webform/manage/test_google_form_handler/handlers/add/webform_googleform');
    $this->submitForm($edit, 'Save');

    $this
      ->assertSession()
      ->pageTextContains('The webform handler was successfully added.');

    $link = $this
      ->getSession()
      ->getPage()
      ->findLink('Google Form');
    $link->click();

    $this
      ->getSession()
      ->getPage()
      ->findLink('edit-delete')
      ->click();
    $this->submitForm([], 'Delete');
    $this
      ->assertSession()
      ->pageTextContains('The webform handler Google Form has been deleted.');
  }

}
