# Webform Google Sheets

[![pipeline status](https://git.drupalcode.org/project/webform_googlesheets/badges/2.x/pipeline.svg)](https://git.drupalcode.org/project/webform_googlesheets/-/commits/2.x)

## Description
This module enables Webform submissions to be automatically added as rows in a Google Sheets spreadsheet. Once installed
it can be found as a submit "Handler" in the Webform settings.

## Requirements
- [Webform](https://www.drupal.org/project/webform) module (^6.0)
- [Google API Client](https://www.drupal.org/project/google_api_client) module (^4.0)
- [Google Cloud Platform](https://console.developers.google.com/) project with Google Sheets API enabled.

## Documentation
- **[Overview](https://www.drupal.org/docs/extending-drupal/contributed-modules/contributed-module-documentation/webform-googlesheets/overview)**
    How Webform submissions are added to the Google Sheet spreadsheet using the Google API PHP Client and a Google
    service account.
- **[Install and configure](https://www.drupal.org/docs/extending-drupal/contributed-modules/contributed-module-documentation/webform-googlesheets/install-and-configure)**
    Step-by-step instructions for installing and configuring the Webform GoogleSheets module, including setting up the
    Google Sheets API, creating a service account, generating a private key, and configuring the Google API PHP Client
    module.
- **[Configure webform](https://www.drupal.org/docs/extending-drupal/contributed-modules/contributed-module-documentation/webform-googlesheets/configure-webform)**
    How to configure webform to append rows to Google Sheets spreadsheet using the handler provided by this module.
- **[Troubleshooting](https://www.drupal.org/docs/extending-drupal/contributed-modules/contributed-module-documentation/webform-googlesheets/troubleshooting)**
    Resolve common issues with Webform GoogleSheets.

## Subscribing to Events

You can subscribe to these events in your event subscriber:

```php
public static function getSubscribedEvents(): array
{
    return [
        WebformGoogleSheetsSuccessEvent::EVENT_NAME => 'onSuccess',
        WebformGoogleSheetsErrorEvent::EVENT_NAME => 'onError',
    ];
}
```

Use this in an `EventSubscriber` to handle success or error cases accordingly.