# Webform Headless

Webform Headless integrates Webform with headless frontends by providing API 
endpoints for managing submissions and getting forms in structured schema 
formats. Currently, only the [FormKit schema](https://formkit.com/essentials/schema) 
is supported, but contributions for other schema formats are welcome.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/webform_headless).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/webform_headless).


## Requirements
This module requires the following modules:

- [Webform](https://www.drupal.org/project/webform)
- [URL Entity](https://www.drupal.org/project/url_entity)


## Installation
Install as you would normally install a contributed Drupal module. For further 
information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration
Enable the module at Administration > Extend.


## Usage

### Fetching the schema
```http request
GET https://{{host}}/webform/{{webformId}}/json/schema?schema={{schemaId}}
Accept: application/json
```

- `webformId` should be the machine name of the webform.
- `schemaId` should be the machine name of the schema. Currently, only `form_kit`
  is supported.

The response contains a JSON object with two keys:
- `schema` contains the schema definition.
- `values` contains the default values for the form.

```json
{
  "schema": [
    {
      "$cmp": "FormKit",
      "props": {
        "type": "form",
        "id": "contact",
        "method": "POST"
      },
      "children": [
        {
          "name": "first_name",
          "id": "contact--first_name",
          "key": "contact--first_name",
          "label": "First name",
          "$formkit": "text",
          "validation": [
            [
              "required"
            ]
          ],
          "classes": {
            "outer": "formkit-outer--first_name"
          },
          "elementType": "textfield"
        },
        {
          "name": "last_name",
          "id": "contact--last_name",
          "key": "contact--last_name",
          "label": "Last name",
          "$formkit": "text",
          "validation": [
            [
              "required"
            ]
          ],
          "classes": {
            "outer": "formkit-outer--last_name"
          },
          "elementType": "textfield"
        },
        {
          "name": "email",
          "id": "contact--email",
          "key": "contact--email",
          "label": "Email",
          "$formkit": "email",
          "validation": [
            [
              "email"
            ]
          ],
          "classes": {
            "outer": "formkit-outer--email"
          },
          "elementType": "email"
        },
        {
          "name": "birth_date",
          "id": "contact--birth_date",
          "key": "contact--birth_date",
          "label": "Birth date",
          "$formkit": "datepicker",
          "value-format": "YYYY-MM-DD",
          "format": "DD\/MM\/YYYY",
          "value-locale": "nl",
          "week-start": "1",
          "max-date": "2008-11-15",
          "placeholder": "DD\/MM\/YYYY",
          "classes": {
            "outer": "formkit-outer--birth_date"
          },
          "elementType": "date"
        }
      ]
    }
  ],
  "values": {
    "campaign_id": "1535"
  }
}
```

### Creating submissions
```http request
POST https://{{host}}/webform/{{webformId}}/json/submission?schema={{schemaId}}
Accept: application/json
Content-Type: application/x-www-form-urlencoded
Referer: https://{{host}}/some-page

email = random@random.com &
first_name = John &
last_name = Harrison
```

- `webformId` should be the machine name of the webform.
- `schemaId` should be the machine name of the schema. Currently, only `formkit`
  is supported.
- The `Referer` header is used for the 'Submitted to' field of the submission.

The request has the same structure as normal webform POSTs. You can find an
example by inspecting a form submission on the webform test page.

The response contains either an array of error messages:
```json
{
  "errors": [
    {
      "message": "Birth date is a required field.",
      "path": [
        "birth_date"
      ]
    }
  ]
}
```

or the submission UUID, values and the confirmation settings:
```json
{
  "uuid": "56201a2f-d19f-4fde-9398-2442c19fee0f",
  "data": {
    "email": "random@random.com",
    "first_name": "John",
    "last_name": "Harrison"
  },
  "confirmation": {
    "type": "url",
    "title": null,
    "url": "\/bedankt?petitionId=[webform_submission:values:uuid]",
    "excludeQuery": null,
    "excludeToken": null,
    "update": null
  }
}
```

### Uploading files
```http request
POST https://{{host}}/webform/{{webformId}}/json/upload
Accept: application/json
Content-Type: application/x-www-form-urlencoded

files[{{elementName}}][]={{file}}
```

- `webformId` should be the machine name of the webform.
- `elementName` should be the name of the file upload element in the webform.
- `file` should be the file data to upload

The response contains either an array of error messages:
```json
{
  "errors": [
    {
      "message": "File could not be saved"
    }
  ]
}
```

or the file IDs of the uploaded files, keyed by the element name
```json
{
  "{{elementName}}": [
    "{{fileId}}"
  ]
}
```

These file IDs can be used in the submission creation request to associate
the uploaded files with the submission.
