<?php

namespace Drupal\webform_headless\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * The WebformJsonSchema attribute.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class WebformJsonSchema extends Plugin {

  /**
   * Constructs a WebformJsonSchema attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $label
   *   The administrative label of the block.
   */
  public function __construct(
    public readonly string $id,
    public readonly ?TranslatableMarkup $label = NULL,
  ) {}

}
