<?php

namespace Drupal\webform_headless\Controller;

use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\webform\WebformInterface;
use Drupal\webform_headless\WebformJsonSchemaManager;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

/**
 * Controller for getting the schema.
 */
class GetSchemaController implements ContainerInjectionInterface {

  /**
   * The schema manager.
   */
  protected readonly WebformJsonSchemaManager $schemaManager;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container): static {
    $instance = new static();
    $instance->schemaManager = $container->get('plugin.manager.webform_headless');

    return $instance;
  }

  /**
   * Gets the schema.
   */
  public function __invoke(WebformInterface $webform, Request $request): JsonResponse {
    $schema = $this->schemaManager->getByRequest($request);
    $data = $schema->toArray($webform, $request);

    return new JsonResponse($data);
  }

}
