<?php

namespace Drupal\webform_headless\Controller;

use Drupal\Core\Cache\CacheableJsonResponse;
use Drupal\Core\Cache\CacheableMetadata;
use Drupal\webform\WebformInterface;

/**
 * Returns the settings for a webform.
 */
class GetSettingsController {

  /**
   * Returns the settings for a webform.
   */
  public function __invoke(WebformInterface $webform): CacheableJsonResponse {
    $data = [];

    $data['confirmation']['type'] = $confirmationType = $webform->getSetting('confirmation_type', TRUE);
    $data['confirmation']['title'] = $webform->getSetting('confirmation_title', TRUE);

    if ($confirmationType === WebformInterface::CONFIRMATION_PAGE) {
      $data['confirmation']['url'] = $webform->getSetting('confirmation_url', TRUE);
      $data['confirmation']['excludeQuery'] = $webform->getSetting('confirmation_exclude_query', TRUE);
      $data['confirmation']['excludeToken'] = $webform->getSetting('confirmation_exclude_token', TRUE);
      $data['confirmation']['update'] = $webform->getSetting('confirmation_update', TRUE);
    }

    if (!in_array($confirmationType, [WebformInterface::CONFIRMATION_URL, WebformInterface::CONFIRMATION_NONE])) {
      $data['confirmation']['message'] = $webform->getSetting('confirmation_message', TRUE);
    }

    if (in_array($confirmationType, [WebformInterface::CONFIRMATION_PAGE, WebformInterface::CONFIRMATION_INLINE])) {
      $data['confirmation']['attributes'] = $webform->getSetting('confirmation_attributes', TRUE);
      $data['confirmation']['back'] = $webform->getSetting('confirmation_back', TRUE);
      $data['confirmation']['backLabel'] = $webform->getSetting('confirmation_back_label', TRUE);
      $data['confirmation']['backAttributes'] = $webform->getSetting('confirmation_back_attributes', TRUE);
    }

    $cacheability = new CacheableMetadata();
    $cacheability->addCacheableDependency($webform);
    $cacheability->addCacheTags(['config:webform.settings']);

    $response = new CacheableJsonResponse($data);
    $response->addCacheableDependency($webform);

    return $response;
  }

}
