<?php

namespace Drupal\webform_headless\Controller;

use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\webform\WebformInterface;
use Drupal\webform\WebformSubmissionInterface;
use Drupal\webform_headless\WebformJsonSchemaManager;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

/**
 * Controller for getting a submission.
 */
class GetSubmissionController implements ContainerInjectionInterface {

  /**
   * The schema manager.
   */
  protected readonly WebformJsonSchemaManager $schemaManager;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container): static {
    $instance = new static();
    $instance->schemaManager = $container->get('plugin.manager.webform_headless');

    return $instance;
  }

  /**
   * Gets the submission.
   */
  public function __invoke(WebformInterface $webform, WebformSubmissionInterface $submission, Request $request): ?JsonResponse {
    if ($submission->getWebform()?->id() !== $webform->id()) {
      throw new NotFoundHttpException();
    }

    $schema = $this->schemaManager->getByRequest($request);

    return new JsonResponse([
      'uuid' => $submission->uuid(),
      'data' => $schema->denormalizeData($submission->getData(), $webform),
    ]);
  }

}
