<?php

namespace Drupal\webform_headless\Controller;

use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\webform\WebformSubmissionInterface;
use Drupal\webform_headless\Submitter;
use Drupal\webform_headless\WebformJsonSchemaManager;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

/**
 * Controller for updating a submission.
 */
class UpdateSubmissionController implements ContainerInjectionInterface {

  /**
   * The submitter.
   */
  protected readonly Submitter $submitter;

  /**
   * The plugin manager.
   */
  protected readonly WebformJsonSchemaManager $schemaManager;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container): static {
    $instance = new static();
    $instance->submitter = $container->get('webform_headless.submitter');
    $instance->schemaManager = $container->get('plugin.manager.webform_headless');

    return $instance;
  }

  /**
   * Updates a submission.
   */
  public function __invoke(WebformSubmissionInterface $submission, Request $request): ?JsonResponse {
    $this->submitter->updateSubmission($submission, $request);
    $schema = $this->schemaManager->getByRequest($request);

    return new JsonResponse([
      'uuid' => $submission->uuid(),
      'data' => $schema->denormalizeData($submission->getData(), $submission->getWebform()),
      'confirmation' => $this->submitter->getConfirmationSettings($submission),
    ]);
  }

}
