<?php

namespace Drupal\webform_headless\EventSubscriber;

use Drupal\Core\EventSubscriber\HttpExceptionSubscriberBase;
use Drupal\webform_headless\Exception\WebformSubmissionException;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Event\ExceptionEvent;

/**
 * Handles json error responses with validation results in a standardised way.
 */
class ExceptionJsonSubscriber extends HttpExceptionSubscriberBase {

  /**
   * {@inheritdoc}
   */
  protected function getHandledFormats(): array {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  protected static function getPriority(): int {
    return -30;
  }

  /**
   * {@inheritdoc}
   */
  public function onException(ExceptionEvent $event): void {
    $exception = $event->getThrowable();
    if (!$exception instanceof WebformSubmissionException) {
      return;
    }

    $response = new JsonResponse(
      [
        'errors' => array_map(
          static fn (string $error) => ['message' => $error],
          $exception->getErrors(),
        ),
      ],
      $exception->getCode() ?: Response::HTTP_BAD_REQUEST,
    );
    $event->setResponse($response);
  }

}
