<?php

namespace Drupal\webform_headless\Exception;

/**
 * Exception thrown when a webform submission fails.
 */
class WebformSubmissionException extends \RuntimeException {

  /**
   * {@inheritdoc}
   */
  public function __construct(string $message = "", int $code = 0, ?\Throwable $previous = NULL) {
    parent::__construct($message, $code, $previous);

    if ($message !== '') {
      $this->addError($message);
    }
  }

  /**
   * The error messages.
   *
   * @var string[]
   */
  protected array $errors = [];

  /**
   * Sets the errors.
   *
   * @param string[] $errors
   *   The error messages.
   *
   * @return static
   *   Returns the current instance for method chaining.
   */
  public function setErrors(array $errors): static {
    $this->errors = $errors;
    return $this;
  }

  /**
   * Adds an error.
   *
   * @param string $error
   *   The error message.
   *
   * @return static
   *   Returns the current instance for method chaining.
   */
  public function addError(string $error): static {
    $this->errors[] = $error;
    return $this;
  }

  /**
   * Gets the errors.
   *
   * @return string[]
   *   The error messages.
   */
  public function getErrors(): array {
    return $this->errors;
  }

}
