<?php

namespace Drupal\webform_headless;

use Drupal\webform\Plugin\WebformElementInterface;

/**
 * Represents a Webform element.
 */
class WebformItem {

  /**
   * The initialized webform element.
   *
   * Can be the uninitialized element in case it's part of a composite element.
   */
  public array $element;

  /**
   * The webform element extracted from the built form.
   */
  public array $builtElement;

  /**
   * The Webform element plugin.
   */
  public WebformElementInterface $elementPlugin;

  /**
   * The child items, in case it's a composite or wrapper element.
   *
   * @var \Drupal\webform_headless\WebformItem[]
   */
  public array $children = [];

  /**
   * Get an element's property value.
   *
   * @param string $propertyName
   *   An element's property name.
   *
   * @return mixed
   *   An element's property value, default value, or NULL if
   *   property does not exist.
   */
  public function getElementProperty(string $propertyName): mixed {
    return $this->element["#$propertyName"]
      ?? $this->builtElement["#$propertyName"]
      ?? $this->elementPlugin->getDefaultProperty($propertyName);
  }

}
