<?php

namespace Drupal\webform_headless;

use Drupal\webform\WebformInterface;
use Drupal\webform\WebformSubmissionInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Determines all features an element type provides and how they can be hidden.
 */
interface WebformJsonSchemaInterface {

  /**
   * Gets the property schema.
   */
  public function getSchema(WebformInterface $webform): array;

  /**
   * Normalizes incoming data to conform to Webform's data structure.
   */
  public function normalizeData(array $data, WebformInterface $webform): array;

  /**
   * Denormalizes incoming data to conform to the schema's data structure.
   */
  public function denormalizeData(array $data, WebformInterface $webform): array;

  /**
   * Gets a full array representation of the schema.
   */
  public function toArray(WebformInterface $webform, Request $request, ?WebformSubmissionInterface $submission = NULL): array;

}
