<?php

/**
 * @file
 * Documentation related to the Webform Headless module.
 */

use Drupal\webform\WebformInterface;

/**
 * Alter the FormKit schema node representing a certain Webform item.
 *
 * @param \Drupal\webform_headless\WebformItem $item
 *   The Webform item.
 * @param array $node
 *   The FormKit schema node.
 */
function hook_webform_headless_formkit_webform_item_schema_alter(\Drupal\webform_headless\WebformItem $item, array &$node): void {
  // Use a custom component for date Webform elements.
  if ($item->element['#type'] === 'date') {
    $node['$formkit'] = 'customDatePicker';
  }
}

/**
 * Alter the resulting FormKit schema.
 *
 * @param \Drupal\webform\WebformInterface $webform
 *   The Webform.
 * @param array $schema
 *   The FormKit schema.
 */
function hook_webform_headless_formkit_schema_alter(WebformInterface $webform, array &$schema): void {
}
