# Webform International Telephone National Mode

This module is provided as a workaround for https://www.drupal.org/project/webform/issues/3278864.

It changes the UX of the out-of-the-box Webform configuration for the telephone element type.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/webform_intl_tel_national_mode).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/webform_intl_tel_national_mode).


## Table of contents

- Requirements
- Recommended modules
- Installation
- Configuration
- Maintainers


## Requirements

This module requires the webform module of course:

- [Webform](https://www.drupal.org/project/webform)


## Installation

Install as you would normally install a contributed Drupal module. For further information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration

Out of the box with the `nationalMode` flag set to false, there are some UX concerns around browser auto-fill values and validation. Suppose that the default country is set to the US and a user has 012 345 6789 saved in their auto-fill settings and fills the form out. Immediately, this user will be faced with a validation error that their input did not start with a +1.

With the updated element configuration, now all of 012 345 6789, 1012 345 6789, and +1012 345 6789 will be happily accepted!

This module overrides the javascript library that ships with Webform for the telephone element. It sets the nationalMode flag and also adds a hidden input element to preserve backwards compatibility in the data collected.

Due to the dynamic nature of adding the hidden input element, the library needed to be overridden instead of simply influenced via `Drupal.webform.intlTelInput.options`.

Just install this module and it will enable the telephone element to enter the numbers below.

## Maintainers

- Luke Leber - [luke.leber](https://www.drupal.org/u/luke.leber)
- Daniel Rodriguez - [danrod](https://www.drupal.org/u/danrod)