Table of contents
-----------------

* Introduction
* Configuration
* Drush


Introduction
------------

The **Webform No Submissions module** provides a toggle to disable all webforms
that save submissions to the database.

The use case for this module occurs during a database migration when you want
to prevent submissions from being lost. Any webform that writes
to the database will be disabled, while webforms that do not save submissions
to the database—because they either send email or push data to an API
—will remain enabled.


Configuration
-------------

- Go to the Webform No Submissions configuration page.
  (/admin/config/development/webform-no-submissions)
- Disable all webforms that save submissions to the database.
- Enter the message to be displayed when a webform is disabled.


Drush
-----

```
# Put site into webform no submissions mode.
drush webform_no_submissions:set 1

# Remove site from webform no submissions mode.
drush webform_no_submissions:set 0
```
