<?php

declare(strict_types=1);

namespace Drush\Commands\core;

namespace Drupal\webform_no_submissions\Drush\Commands;

use Drupal\Core\Cache\CacheTagsInvalidatorInterface;
use Drupal\Core\State\StateInterface;
use Drush\Attributes as CLI;
use Drush\Commands\AutowireTrait;
use Drush\Commands\DrushCommands;

/**
 * Provides Drush commands to manage webform no submissions mode.
 *
 * Copied from core maintenance mode commands.
 *
 * @see \Drush\Commands\core\MaintCommands
 */
class WebformNoSubmissionsCommands extends DrushCommands {
  use AutowireTrait;

  public function __construct(
    protected StateInterface $state,
    protected CacheTagsInvalidatorInterface $cacheTagsInvalidator,
  ) {}

  /**
   * Set webform no submissions mode.
   */
  #[CLI\Command(name: 'webform_no_submissions:set')]
  #[CLI\Argument(name: 'value', description: 'The value to assign to the state key', suggestedValues: ['0', '1'])]
  #[CLI\Usage(name: 'drush webform_no_submissions:set 1', description: 'Put site into webform no submissions mode.')]
  #[CLI\Usage(name: 'drush webform_no_submissions:set 0', description: 'Remove site from webform no submissions mode.')]
  public function set(string $value): void {
    $this->state->set('webform_no_submissions', (bool) $value);
    $this->cacheTagsInvalidator->invalidateTags(['config:webform_no_submissions.settings']);
  }

}
