Webform Open Postcode
=====================

Webform Open Postcode integrates the Open Postcode (openpostcode.nl) API with
Drupal Webform to provide automatic, *free* Dutch address lookup functionality.
When users enter a postcode and house number in a webform, this module
automatically populates related address fields (street, city) using the Open
Postcode API, without the need for API keys or subscription fees. See
[Open Postcode](https://openpostcode.nl/) for more information.

Note: this module does not work work with the Webform address fields, because it
needs separate street and house number fields. Also, the UX requires the
internationally somewhat odd order of first asking for postal code and house
number. Because of this, the form needs to use separate fields for all parts of
the address.

Table of contents
------------------

- Requirements
- Installation
- Configuration
- Troubleshooting
- Maintainers

Requirements
------------

- Drupal 10 or 11
- [Webform](https://www.drupal.org/project/webform) module
- PHP 8.1 or higher
- Internet connection (for API calls to openpostcode.nl)

Installation
------------

Install as you would normally install a contributed Drupal module. For further
information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

Configuration
-------------

### Configuring a Webform Element

1. Edit your webform and navigate to the element you want to use as the postcode
   input field.
2. In the element configuration form, expand the "Open Postcode" section
3. Enable the checkbox "Enable Open Postcode lookup on this element"
4. Configure the following settings:
   - **House number element key**: The webform element key that contains the
     house number (e.g., `huisnummer`)
   - **Street target element key**: The element key where the street name should
    be populated (e.g., `straat`)
   - **City target element key**: The element key where the city name should be
     populated (e.g., `woonplaats`)

Tip: a valid Dutch address might include an addition to the house number, e.g.
"1A". The Open Postcode API is fine with the addition being included in the
house number field. It is up to you whether you want to split the house number
into two fields, or use a single field with the addition included.

### Example Configuration

If you have a webform with the following elements:
- `postcode` - Postcode field
- `huisnummer` - House number field
- `straat` - Street field
- `woonplaats` - City field

Configure the `postcode` element with:
- Enable Open Postcode lookup: ✓
- House number element key: `huisnummer`
- Street target element key: `straat`
- City target element key: `woonplaats`

Troubleshooting & FAQ
---------------------

- An API key is not required.
- If values don’t populate, verify both postcode and house number are filled.
- Check logs (channel `webform_openpostcode`) for lookup failures.
- Cached results persist for 12 hours; clear caches to re-test fresh results.

Maintainers
-----------

- Eelke Blok - [eelkeblok](https://www.drupal.org/u/eelkeblok)
