<?php

declare(strict_types=1);

namespace Drupal\webform_openpostcode\Hook;

use Drupal\Core\Hook\Attribute\Hook;

/**
 * Hook implementations for default webform element properties.
 */
final class PropertiesHooks {

  /**
   * Add default properties for Open Postcode to all elements.
   *
   * @param array $properties
   *   Default element properties.
   * @param array $definition
   *   Element definition.
   */
  #[Hook('webform_element_default_properties_alter')]
  public function defaultPropertiesAlter(array &$properties, array &$definition): void {
    // Add our properties. Webform will map these into the element render array
    // as '#op_*' for use at render time.
    $properties['op_enable'] = 0;
    $properties['op_number_key'] = '';
    $properties['op_street_target_key'] = '';
    $properties['op_city_target_key'] = '';
  }

}
