<?php

declare(strict_types=1);

namespace Drupal\webform_openpostcode\Service;

/**
 * Contract for Open Postcode lookup services.
 */
interface OpenPostcodeLookupInterface {

  /**
   * Lookup address data for a postcode/house number combination.
   *
   * @param string $postcode
   *   The postcode (will be normalized internally).
   * @param string $houseNumber
   *   The house number.
   *
   * @return array
   *   The lookup result data (e.g. straat, woonplaats).
   *
   * @throws \InvalidArgumentException
   *   Thrown when the provided input is incomplete.
   * @throws \RuntimeException
   *   Thrown when the lookup fails.
   */
  public function lookup(string $postcode, string $houseNumber): array;

}
