<?php

declare(strict_types=1);

namespace Drupal\Tests\webform_openpostcode\Unit\Hook;

use Drupal\Tests\UnitTestCase;
use Drupal\webform_openpostcode\Hook\PropertiesHooks;

/**
 * @covers \Drupal\webform_openpostcode\Hook\PropertiesHooks
 * @group webform_openpostcode
 */
final class PropertiesHooksTest extends UnitTestCase {

  /**
   * Test that the defaults are correctly added.
   */
  public function testDefaultsAreAdded(): void {
    $hooks = new PropertiesHooks();
    $properties = [];
    $definition = [];
    $hooks->defaultPropertiesAlter($properties, $definition);

    $this->assertArrayHasKey('op_enable', $properties);
    $this->assertArrayHasKey('op_number_key', $properties);
    $this->assertArrayHasKey('op_street_target_key', $properties);
    $this->assertArrayHasKey('op_city_target_key', $properties);
    $this->assertSame(0, $properties['op_enable']);
    $this->assertSame('', $properties['op_number_key']);
    $this->assertSame('', $properties['op_street_target_key']);
    $this->assertSame('', $properties['op_city_target_key']);
  }

}
