## INTRODUCTION

The Webform Payment Element module contains a new custom webform element called payment element and a custom token.

The payment element allows for advanced payment options that call for more than a simple key -> value mapping.
The element allows for multiple items, each one containing
 - name (machine/unique)
 - amount (number)
 - title (displayed)
 - description (optional)

So that you can create an element with a unique machine name, a display name and a dollar amount associated with that item.
An optional description also allows you to provide more information to users. These items can be configured as either radio or checkboxes depeneding on the cardinality.

There is also a custom token provided called TOKEN_NAME that will loop through the choices selected across all payment elements and total them up.  Allowing for easy submission handling of the total amount selected in the form.

Lastly this module comes with an example form so you can see a usecase for the element. This example form will be installed when the module is enabled, but can be deleted later. The example form is also used for testing purposes.

## MAINTAINERS

- Devan Bicher - https://www.drupal.org/u/devanbicher
- Jacob Rockowitz - https://www.drupal.org/u/jrockowitz


## TODO

- Add the below files (copy from webform module)
  - (what do I need from this file) composer.json

- Create MR for webform module to note using `{# data.element_key #}` comments in the Twig code.

- Results export formatter

## DEVELOPMENT

```bash
ddev drush en -y webform_payment_element;
ddev drush dre webform_payment_element;
ddev drush pmu -y webform_payment_element;
```
