<?php

namespace Drupal\webform_payment_element\Plugin\WebformElement;

use Drupal\Core\Form\FormStateInterface;
use Drupal\webform\Plugin\WebformElement\WebformComputedBase;

/**
 * Provides a 'webform_payment_element_total' element.
 *
 * @WebformElement(
 *   id = "webform_payment_element_total",
 *   label = @Translation("Webform payment element total"),
 *   description = @Translation("Provides a webform element payment total."),
 *   category = @Translation("Payment elements"),
 * )
 */
class WebformPaymentElementTotal extends WebformComputedBase {

  /**
   * {@inheritdoc}
   */
  protected function defineDefaultProperties() {
    $default_properties = [
      'amount_precision' => 2,
      'amount_prefix' => '$ ',
      'amount_suffix' => '',
      'amount_thousands_separator' => ',',
      'amount_decimal_separator' => '.',
    ] + parent::defineDefaultProperties();
    unset(
      $default_properties['template'],
      $default_properties['prepopulate'],
    );
    return $default_properties;
  }

  /* ************************************************************************ */

  /**
   * {@inheritdoc}
   */
  public function form(array $form, FormStateInterface $form_state) {
    $form = parent::form($form, $form_state);

    $form['webform_payment_total'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Payment total'),
      '#description' => $this->t('Enter how you want the payment amount to be displayed.'),
    ];
    $form['webform_payment_total']['amount_precision'] = [
      '#type' => 'select',
      '#title' => $this->t('Precision'),
      '#description' => $this->t('The number of decimal places to display in the amount (0-10).'),
      '#required' => TRUE,
      '#options' => range(0, 5),
    ];
    $form['webform_payment_total']['parts'] = $this->getFormInlineContainer();
    $form['webform_payment_total']['parts']['amount_prefix'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Prefix'),
      '#description' => $this->t('Text or symbol to display before the amount (e.g., "$").'),
    ];
    $form['webform_payment_total']['parts']['amount_suffix'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Suffix'),
      '#description' => $this->t('Text or symbol to display after the amount (e.g., "USD").'),
    ];

    $form['webform_payment_total']['separator'] = $this->getFormInlineContainer();
    $form['webform_payment_total']['separator']['amount_thousands_separator'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Thousands separator'),
      '#description' => $this->t('Character to use as thousands separator (e.g., ",").'),
    ];
    $form['webform_payment_total']['separator']['amount_decimal_separator'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Decimal separator'),
      '#description' => $this->t('Character to use as decimal separator (e.g., ".").'),
    ];

    return $form;
  }

}
