<?php

namespace Drupal\Tests\webform_payment_element\Functional;

use Drupal\Tests\webform\Functional\WebformBrowserTestBase;

/**
 * Tests the Webform payment element test webform functionality.
 */
class WebformPaymentElementFunctionalTest extends WebformBrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'webform',
    'webform_payment_element',
  ];

  /**
   * Tests the Webform payment element test webform submission.
   */
  public function testWebformPaymentElement(): void {
    $webform = $this->loadWebform('webform_payment_element');

    // Fill out some data in the form.
    $edit = [
      'radios[items]' => 'radios_item_1',
      'checkboxes[items][checkboxes_item_2]' => TRUE,
      'select[items]' => 'select_item_3',
      'tableselect[items][tableselect_item_1]' => TRUE,
      'tableselect[items][tableselect_item_2]' => TRUE,
    ];

    $this->drupalGet('webform/webform_payment_element');

    // Check radios element rendering with description.
    $this->assertSession()->responseContains('<label for="edit-radios-items-radios-item-1" class="option">Item 1 - $ 9.99</label>');
    $this->assertSession()->responseContains('<div id="edit-radios-items-radios-item-1--description" class="webform-element-description">Item 1 description</div>');

    // Check checkboxes element rendering with description.
    $this->assertSession()->responseContains('<label for="edit-checkboxes-items-checkboxes-item-1" class="option">Item 1 - $ 10.00</label>');
    $this->assertSession()->responseContains('<div id="edit-checkboxes-items-checkboxes-item-1--description" class="webform-element-description">Item 1 description</div>');

    // Check select element rendering without description.
    $this->assertSession()->responseContains('<select data-drupal-selector="edit-select-items" id="edit-select-items" name="select[items]" class="form-select">');
    $this->assertSession()->responseContains('<option value="" selected="selected">- None -</option>');
    $this->assertSession()->responseContains('<option value="select_item_1">Item 1 - $ 10.00</option>');
    $this->assertSession()->responseContains('<option value="select_item_2">Item 2 - $ 10.00</option>');
    $this->assertSession()->responseContains('<option value="select_item_3">Item 3 - $ 10.00</option>');

    // Check tableselect element rendering description.
    $this->assertSession()->responseContains('<div class="js-webform-type-webform-payment-element webform-type-webform-payment-element js-form-item form-item js-form-type-webform-payment-element form-item-tableselect js-form-item-tableselect">');
    $this->assertSession()->responseContains('<label for="edit-tableselect">Table select</label>');
    $this->assertSession()->responseContains('<table data-drupal-selector="edit-tableselect-items" id="edit-tableselect-items" class="responsive-enabled" data-striping="1">');
    $this->assertSession()->responseContains('<td><div class="js-form-item form-item js-form-type-checkbox form-item-tableselect-items-tableselect-item-1 js-form-item-tableselect-items-tableselect-item-1 form-no-label">');
    $this->assertSession()->responseContains('<input data-drupal-selector="edit-tableselect-items-tableselect-item-1" type="checkbox" id="edit-tableselect-items-tableselect-item-1" name="tableselect[items][tableselect_item_1]" value="tableselect_item_1" class="form-checkbox" />');
    $this->assertSession()->responseContains('<td><strong>Item 1</strong><br />Item  description</td>');
    $this->assertSession()->responseContains('<td>$ 10.00</td>');

    // Check the output of the preview, e.g. Item 1 - $ 9.99
    // Click on preview button.
    $this->submitForm($edit, 'Preview');
    // Radios preview.
    $this->assertSession()->pageTextContains('Item 1 - $ 9.99');
    // Checkboxes preview.
    $this->assertSession()->responseContains('<ul><li>Item 2 - $ 10.00</li></ul>');
    // Tableselect preview.
    $this->assertSession()->responseContains('<ul><li>Item 1 - $ 10.00</li><li>Item 2 - $ 10.00</li></ul>');
    // Total preview.
    $this->assertSession()->responseContains('<label>Total</label>');
    $this->assertSession()->responseContains('$ 49.99');

    // Submit the form.
    $sid = $this->postSubmission($webform, $edit);

    // Verify the submission results.
    $this->assertSession()->responseContains("radios: radios_item_1
checkboxes:
  - checkboxes_item_2
select: select_item_3
tableselect:
  - tableselect_item_1
  - tableselect_item_2
total: '49.99'
total_displayed: '$ 49.99'");

    $this->drupalLogin($this->rootUser);
    $this->drupalGet("admin/structure/webform/manage/webform_payment_element/submission/$sid");
    $this->assertSession()->statusCodeEquals(200);
    $this->assertSession()->pageTextContains('$ 49.99');
  }

}
